package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.api.DestinationI;
import com.avaya.ccs.javafxrefclient.Logger;

public class InitiateTransferToDestinationRequest extends InteractionRequest {

	 private static final Logger LOG = Logger.getLogger(InitiateTransferToDestinationRequest.class);
	    private final DestinationI destination;

	    public InitiateTransferToDestinationRequest(String interactionID, DestinationI destination) {
	        super(LOG, interactionID);
	        this.destination = destination;
	    }

	    /**
	     * The call method executes on the outgoingRequest thread
	     *
	     * @return
	     * @throws Exception
	     */
	    @Override
	    protected Object call() throws Exception {
	        String methodName = "call() ";
	        LOG.trace(methodName + "+");
	        getInteraction().initiateTransferToDestination(destination);
	        LOG.trace(methodName + "-");
	        return null;
	    }

}
